function [punc_data] = punc_locodist(varargin)
%This function is a nerfed version of punc_metric for distance calculations
%only, and only the nearest point... that helps the user perform a puncta
%wise colocaliztion analysis.  The user will enter a minimum of two x y z
%coordinate lists and the program will spit out a structure of distances
%and vector metrics.
%Synatax:   [punc_data] = punc_locodist('nhood',20); 
%Input:     This function does not really require any inputs.  However if
%           you do not want default values then..
%           'nhood' = the search neighborhood around each vertex for its
%                   nearest neighbor.  Default = 5 each direction
%           'center' = value of 1 or 0, 0 = off, 1 = on.  When center is on
%                   calculations for vectors will be made towards a point
%                   between the two defined points, and there will be an
%                   extra dataset for the distance meteric which will
%                   represent the center between the two selected points.
%                   Default = 0.
%           'vector' = value of 1 or 0, 0 = off, 1 = on.  When on the
%                   vector metric will be attempted for the data input.
%                   Default = 1.
%           'x' = the scale, as a ratio or xyz, of 1 unit in the x axis.
%                 Default = 1
%           'y' = the scale, as a ratio or xyz, of 1 unit in the y axis.
%                 Default = 1
%           'z' = the scale, as a ratio or xyz, of 1 unit in the z axis.
%                 Default = 1
%           'nrst_only' = Calculate vector using the nearst points as well. 
%                   otherwise, vector will be calculated using the full
%                   list of vertices in the nhood volumn.  Default = 0/off.
%                   1 = on.
%           'noself' = special case if you want to compare a list to
%                   itself, but don't want all points to be 0.  So, the
%                   nearest point not self.  Default = 0(off)
%Output:    Punc_data = a structured array with the data for puncta data
%           The structure of the data set is this:
%             filenames = the filenames of the channels
%             pathnames = where the files are stored
%           Distance Metric:
%             punc_data is a structure of depth x, where x is the number of
%             imported vertices lists, or layers of data
%             punc_data(x).distance = An n by 1 array where n matches the
%               number of verticies in that particular list.
%             punc_data(x).vertices = An n by 3 array of vertices that was
%               used as the ori vertex for generating the distances.
%             punc_data(x).vert_props = an n by m by z matrix, where n is
%               the number of ori vertices, m is the number of properties
%               gathered and z is the number of channels assayed.  In this
%               case the properties are matched the properties of only
%               those vertices that are in a ori-termi pair are stored for
%               each pair.  If there is no pair, NaN is put in its place
%             punc_data(x).vert_all_props = an n by m array, where all of
%               properties of the vertices are store.
%             punc_data(x).termi = n by 3 by z matrix where n is the number
%               of ori vertices, and z is the number of channels, this
%               matrix stores the vertices of all of the termi vertices in
%               the ori-termi pair
%             punc_data(x).termi_prop = n by m by z matrix of all of the
%               properties of the termi vertices in the ori-termi pair.

[nhood,center,x_scale,y_scale,z_scale,nrst_only,noself] = parse(varargin);     %Parse the input

%import vertex files
%open the first vertex file. Prompt first
prompt_box('title','Open Vertex Lists','prompt1','Select the vertex lists you want to compare.','position','center');
pause(0.25);
open_data = 0;      %initialize open files switch
vertices = {};      %initialize vertex array
filenames = {};
pathnames = {};  
while open_data==0
    %this line helps get around the 100 file limitation
    setappdata(0,'UseNativeSystemDialogs',false)
    %get files. Note: currently the filterindex is the filter selected for the file selection.
    [filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.xlsx','Excel 2007 files (*.xlsx)';...
        '*.xls','Excel files (*.xls)';'*.mat','Mat files (*.mat)';'*.*','All Files';},...
        'Open Stack','Multiselect','on');
    setappdata(0,'UseNativeSystemDialogs',true)
    %you must load at least two data sets
    if filterindex~=4       %mat files are treated differently
        if ischar(filename_tmp)
            error('You must load at least two data sets.')
        end
    elseif ischar(filename_tmp)     %if is mat file make the single file a 1x1 cell array so it will work.
        filename_tmp = {filename_tmp};
    end
    %Now open the data sets according to the filter used.
    switch filterindex
        case {2,3}              %excel file
            for i = 1:size(filename_tmp,2)
                verti_tmp{i} = single(xlsread([pathname_tmp,filename_tmp{1,i}]));
            end
            vertices = cat(2,vertices,verti_tmp);       %join all the opened data together
        case {1,5}                  %text file - Default coma delimited
            for i = 1:size(filename_tmp,2)
                %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
                verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],',',1,0));
            end
            vertices = cat(2,vertices,verti_tmp);       %join all the opened data together
        otherwise               %MAT FILES      - Note Note supported right now.
            for i = 1:size(filename_tmp,2)
                load([pathname_tmp,filename_tmp{1,i}]);
            end
    end
    filenames = cat(2,filenames,filename_tmp);
    pathnames = cat(2,pathnames,pathname_tmp);
    open_data = yes_no_box('title','Are you done selecting data?','caption1','Select yes is you want to move on.',...
        'caption2','Select no if you want to import another dataset.','position','center');
end
%clean up
clear verti_tmp filename_tmp pathname_tmp

%store the file properties
punc_data.filenames = filenames;
punc_data.pathnames = pathnames;
punc_data.vector = 0;               %no vector calculations

%begin parallelization
parpool      %initiate processes

%now lets calculate the distance metric
[punc_data] = distance_cal(filenames,vertices,punc_data,nhood,x_scale,y_scale,z_scale,nrst_only,noself);

%save the file
%strmask = isstrprop(filenames,'alpha');
filenames_tmp = 'puncdata';
for j = 1:size(filenames,2)
    strmask = isspace(filenames{j});
    spcloc = find(strmask==1);
    %filenames_tmp = [filenames_tmp '.' filenames{j}(strmask{j}(1:end-4))];
    filenames_tmp = [filenames_tmp '.' strtrim(filenames{j}(min(spcloc):max(spcloc)))];
end
save([pathnames{1},filenames_tmp,'.mat'],'punc_data');

%closing time
delete(gcp('nocreate'))

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [nhood,center,x_scale,y_scale,z_scale,nrst_only,noself] = parse(input)

nhood = 10;  %Default Initialized.
center = 0;  %Center is off at default
x_scale = 1;    %base scale of a unit in the x axis
y_scale = 1;    %base scale of a unit in the y axis
z_scale = 1;    %base scale of a unit in the z axis
nrst_only = 0;  %Nearest off by default
noself = 0;

%Parse the input
if ~isempty(input)
    for i = 1:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'nhood'
                    nhood = input{1,i+1};
                case 'center'
                    center = input{1,i+1};
                case 'x'
                    x_scale = input{1,i+1};
                case 'y'
                    y_scale = input{1,i+1};
                case 'z'
                    z_scale = input{1,i+1};
                case 'nrst_only'
                    nrst_only = input{1,i+1};
                case 'noself'
                    noself = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        end
    end
end

%--------------------------------------------------------------------------
%subfunction to calculate the distance metric.
function [punc_data] = distance_cal(filenames,vertices,punc_data,nhood,x_scale,y_scale,z_scale,nrst_only,noself)

%If not subtraction list is presented, do not subtract any point from the
%data structure.
if nargin==4
    sub_list = 0;
end

%parallelize this puppy
%matlabpool      %initiate processes

%now lets calculate the distance metric
%h = waitbar(0,['Data Sets Analyzed: ',filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
for i = 1:size(filenames,2)      %calculate for each data set
    %seperate out the brightness value
    verti_tmp = vertices{1,i}(:,1:3);     %pull out one data set to work with
    bright_tmp = single(vertices{1,i}(:,4:end));        %brightness data for each vertices
    verti_tmp = single(verti_tmp.*repmat([x_scale y_scale z_scale],size(verti_tmp,1),1));   %scale the vertices to the proper unit
    %preload cell arrays
    dist_tmp = zeros(size(verti_tmp,1),1,size(filenames,2));       %shortest distances
    %verti_match = cell(size(verti_tmp,1),1,size(filenames,2)); %the matching original verticies for the closeset points.
    %v_match_lum = cell(size(verti_tmp,1),1,size(filenames,2)); %the matching luminance values
    %dist_verti_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %the matching distance matrix to the closest point list. A cell array as well.
    %closest_tmp = cell(size(verti_tmp,1),1,size(filenames,2));  %the closest pivot.  A cell array.
    %closest_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));  %the matching lumninace data.  A cell array
    termi_tmp = zeros(size(verti_tmp,1),3,size(filenames,2));       %the termi vertices
    termi_prop_tmp = zeros(size(verti_tmp,1),size(bright_tmp,2),size(filenames,2)); %the termi properties
    %short_tmp = cell(size(verti_tmp,1),1,size(filenames,2));    %The short list.  A cell Array.
    %short_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));    %The short list luminance.  A cell array.
    %sl_dist_tmp = cell(size(verti_tmp,1),1,size(filenames,2));     %The short list distances.  A cell Array.
    %sl_verti_match_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %The matching verticies for the short list points.
    %sl_v_match_lum_tmp = cell(size(verti_tmp,1),1,size(filenames,2));   %The matching luminance data.
    %start progress bar
    %h2 = waitbar(0,['Comparing Data Set: ',filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
    for j = 1:size(filenames,2)      %get the comparision set
        if j~=i                     %skip if it is the base set
            verti_co_tmp = vertices{1,j}(:,1:3).*repmat([x_scale y_scale z_scale],size(vertices{1,j},1),1);   %scale the vertices to the proper unit
            bright_co_tmp = vertices{1,j}(:,4:end);     %matching brightness data for comparision channel, now include other properties
            %h3 = waitbar(0,'Vertex Distance Analyzed: 0');    %initialize progress bar.
            parfor k = 1:size(verti_tmp,1)     %iterate through each vertex of the set
                display(['distance ',filenames{1,i},' ',filenames{1,j},' ',num2str(i),'_',num2str(j),'_',num2str(k)]);
                [short_list short_list_lum] = find_neighbors(verti_tmp(k,:),verti_co_tmp,nhood*2,bright_co_tmp);    %get a short list of local pivots (removed:,bright_co_tmp)
                curr_verti = repmat(verti_tmp(k,:),size(short_list,1),1);         %replicate the current vertex to the size of the short list.
                if noself       %special case not self
                    [y,x] = find(short_list(:,1)==curr_verti(:,1)&short_list(:,2)==curr_verti(:,2)&short_list(:,3)==curr_verti(:,3));  %find self vertex
                    short_list(y,:) = [];       %gone
                    short_list_lum(y,:) = [];   %gone
                    curr_verti(y,:) = [];       %gone
                end
                %now we are going to make this a search in a sphere
                verti_dist = single(dddist(curr_verti,short_list));     %calculate the distance of the current vertex from all points in the short list.
                idx = verti_dist>nhood;     %any point actually outside of the specified radius
                verti_dist(idx) = [];       %gone
                short_list(idx,:) = [];     %gone
                short_list_lum(idx,:) = []; %gone
                curr_verti(idx,:) = [];     %gone
                if ~isempty(short_list)           %make sure there is something in the neighborhood.
                    [x,y] = find(verti_dist==absmin(verti_dist));   %find the position of the closest point
                    %closest_tmp{k,1,j} = short_list(x,:);           %create a cell array of all the closest points, just in case of multiples.
                    %closest_lum_tmp{k,1,j} = short_list_lum(x,:);   %create a matching cell array of luminance
                    termi_tmp(k,:,j) = short_list(x(1,1),:);        %for now all I care about is the first closest point, switch to closest_tmp for more complete view
                    termi_prop_tmp(k,:,j) = short_list_lum(x(1,1),:);  %termi properties to match termi
                    %verti_match{k,1,j} = repmat(verti_tmp(k,:),size(short_list(x,:),1),1);    %create a matching original verticies for the closets pts.
                    %v_match_lum{k,1,j} = repmat(bright_tmp(k,:),size(short_list(x,:),1),1);
                    %dist_verti_tmp{k,1,j} = verti_dist(x,:);  %create a matching set of distances with the vertices.
                    dist_tmp(k,1,j) = verti_dist(x(1,1),:);              %create a columnar vector of shortest distances
                    vert_prop(k,:,j) = bright_tmp(k,:);         %store the vertices associated properties
                    %short_tmp{k,1,j} = short_list;    %output the short list as well.
                    %short_lum_tmp{k,1,j} = short_list_lum;  %output the luminances of the short list as well
                    %sl_dist_tmp{k,1,j} = verti_dist;  %output the distances for all points in the short list.
                    %sl_verti_match_tmp{k,1,j} = repmat(verti_tmp(k,:),size(short_list,1),1);  %create a matching vertices for the short list
                    %sl_v_match_lum_tmp{k,1,j} = repmat(bright_tmp(k,:),size(short_list,1),1);  %create a matching luminance for the short list
                else                        %there is no one around me (sad)
                    %closest_tmp{k,1,j} = single([NaN NaN NaN]);           %not a number for easy extraction.
                    %closest_lum_tmp{k,1,j} = single(NaN(1,size(bright_tmp,2)));
                    termi_tmp(k,:,j) = single([NaN NaN NaN]);
                    termi_prop_tmp(k,:,j) = single(NaN(1,size(bright_tmp,2)));
                    %verti_match{k,1,j} = verti_tmp(k,:);    
                    %v_match_lum{k,1,j} = bright_tmp(k,:);
                    %dist_verti_tmp{k,1,j} = single(NaN);  
                    dist_tmp(k,1,j) = single(NaN);
                    vert_prop(k,:,j) = single(NaN(1,size(bright_tmp,2)));
                    %short_tmp{k,1,j} = single([NaN NaN NaN]);    %output the short list as well.
                    %short_lum_tmp{k,1,j} = single(NaN);
                    %sl_dist_tmp{k,1,j} = single(NaN);   %output the distance for short list.
                    %sl_verti_match_tmp{k,1,j} = verti_tmp(k,:);  %all by yourself
                    %sl_v_match_lum_tmp{k,1,j} = bright_tmp(k,:);
                end
                %waitbar(k/size(verti_tmp,1),h3,['Vertex Distance Analyzed: ',num2str(k)]);   %update progress
            end
            %close(h3);   %close progress bar
            %waitbar(j/size(filenames,2),h2,['Comparing Data Set: ',filenames{j}]);   %update progress
        end
    end
    %store the data. The structure is that the distance is a matrix that
    %corresponds with the vertices list in the rows and with each z step a
    %calculation against another dataset, the self to self comparision data
    %set is all 0.  So 4 datasets, will be a matrix of (x,1,4).  The
    %vertices is just the verticies used to calculate the distance.  The
    %closest_pt dataset is a cell array that matches the verticies list in
    %rows and with each z step representing another dataset, the cell array
    %is used for the instances where there are multiple closest points.
    punc_data(i).distance = dist_tmp;       %shortest distances
    punc_data(i).vertices = verti_tmp;      %the vertices 
    punc_data(i).vert_prop = vert_prop;     %the property value for only the vertices that have a neighbor in that particular channel
    punc_data(i).vert_all_prop = bright_tmp;          %The property value for all of the vertices in this channel
    %punc_data(i).verti_match = verti_match; %the matching original verticies for the closeset points.
    %punc_data(i).v_match_lum = v_match_lum; %the matching luminance values
    %punc_data(i).dist_verti = dist_verti_tmp;   %the matching distance matrix to the closest point list. A cell array as well.
    %punc_data(i).closest_pt = closest_tmp;  %the closest pivot.  A cell array.
    %punc_data(i).closest_prop = closest_lum_tmp;  %the matching property data for the closest pivots.  A cell array
    punc_data(i).termi = termi_tmp;         %the matching terminal vertices
    punc_data(i).termi_prop = termi_prop_tmp;   %the matching properties for the terminal vertices
    %punc_data(i).short_list = short_tmp;    %The short list.  A cell Array.
    %punc_data(i).short_list_lum = short_lum_tmp;    %The short list luminance.  A cell array.
    %punc_data(i).sl_dist = sl_dist_tmp;     %The short list distances.  A cell Array.
    %punc_data(i).sl_verti_match = sl_verti_match_tmp;   %The matching verticies for the short list points.
    %punc_data(i).sl_v_match_lum = sl_v_match_lum_tmp;   %The matching luminance data.
    %clear data for reinitialization
    %clear verti_tmp verti_co_tmp dist_tmp closest_tmp verti_match dist_verti_tmp short_tmp sl_dist_tmp sl_verti_match_tmp bright_tmp bright_co_tmp closest_lum_tmp v_match_lum short_lum_tmp sl_v_match_lum_tmp
    %verti_tmp = []; verti_co_tmp = []; dist_tmp = []; vert_prop = [];bright_tmp = [];short_lum_tmp = [];bright_co_tmp = [];termi_tmp = [];termi_prop_tmp = [];
    %verti_match = []; v_match_lum = [];sl_verti_match_tmp = []; sl_v_match_lum_tmp =[];dist_verti_tmp = [];closest_tmp = [];closest_lum_tmp = [];
    %short_tmp = []; sl_dist_tmp = []; 
    %update progress bars
    %close(h2);   %close progress bar
    %waitbar(i/size(filenames,2),h,['Data Sets Analyzed: ',filenames{i}]);   %update progress
    clear curr_verti short_list short_list_lum verti_dist bright_tmp 
end
%close(h);   %close progress bar
%clear verti_tmp verti_co_tmp dist_tmp closest_tmp verti_match dist_verti_tmp short_tmp sl_dist_tmp sl_verti_match_tmp bright_tmp bright_co_tmp closest_lum_tmp v_match_lum short_lum_tmp sl_v_match_lum_tmp
%matlabpool close %close processes